// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/dom_distiller/content/common/distiller_javascript_service.mojom
//

package org.chromium.mojom.dom_distiller;

class DistillerJavaScriptService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<DistillerJavaScriptService, DistillerJavaScriptService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<DistillerJavaScriptService, DistillerJavaScriptService.Proxy>() {
    
        public String getName() {
            return "dom_distiller::DistillerJavaScriptService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, DistillerJavaScriptService impl) {
            return new Stub(core, impl);
        }
    
        public DistillerJavaScriptService[] buildArray(int size) {
          return new DistillerJavaScriptService[size];
        }
    };

    private static final int HANDLE_DISTILLER_ECHO_CALL_ORDINAL = 0;
    private static final int HANDLE_DISTILLER_FEEDBACK_CALL_ORDINAL = 1;
    private static final int HANDLE_DISTILLER_CLOSE_PANEL_CALL_ORDINAL = 2;
    private static final int HANDLE_DISTILLER_OPEN_SETTINGS_CALL_ORDINAL = 3;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements DistillerJavaScriptService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void handleDistillerEchoCall(String message) {
            DistillerJavaScriptServiceHandleDistillerEchoCallParams _message = new DistillerJavaScriptServiceHandleDistillerEchoCallParams();
            _message.message = message;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(HANDLE_DISTILLER_ECHO_CALL_ORDINAL)));
        }

        @Override
        public void handleDistillerFeedbackCall(boolean good) {
            DistillerJavaScriptServiceHandleDistillerFeedbackCallParams _message = new DistillerJavaScriptServiceHandleDistillerFeedbackCallParams();
            _message.good = good;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(HANDLE_DISTILLER_FEEDBACK_CALL_ORDINAL)));
        }

        @Override
        public void handleDistillerClosePanelCall() {
            DistillerJavaScriptServiceHandleDistillerClosePanelCallParams _message = new DistillerJavaScriptServiceHandleDistillerClosePanelCallParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(HANDLE_DISTILLER_CLOSE_PANEL_CALL_ORDINAL)));
        }

        @Override
        public void handleDistillerOpenSettingsCall() {
            DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams _message = new DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(HANDLE_DISTILLER_OPEN_SETTINGS_CALL_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<DistillerJavaScriptService> {

        Stub(org.chromium.mojo.system.Core core, DistillerJavaScriptService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DistillerJavaScriptService_Internal.MANAGER, messageWithHeader);
                    case HANDLE_DISTILLER_ECHO_CALL_ORDINAL: {
                        DistillerJavaScriptServiceHandleDistillerEchoCallParams data =
                                DistillerJavaScriptServiceHandleDistillerEchoCallParams.deserialize(messageWithHeader.getPayload());
                        getImpl().handleDistillerEchoCall(data.message);
                        return true;
                    }
                    case HANDLE_DISTILLER_FEEDBACK_CALL_ORDINAL: {
                        DistillerJavaScriptServiceHandleDistillerFeedbackCallParams data =
                                DistillerJavaScriptServiceHandleDistillerFeedbackCallParams.deserialize(messageWithHeader.getPayload());
                        getImpl().handleDistillerFeedbackCall(data.good);
                        return true;
                    }
                    case HANDLE_DISTILLER_CLOSE_PANEL_CALL_ORDINAL: {
                        DistillerJavaScriptServiceHandleDistillerClosePanelCallParams.deserialize(messageWithHeader.getPayload());
                        getImpl().handleDistillerClosePanelCall();
                        return true;
                    }
                    case HANDLE_DISTILLER_OPEN_SETTINGS_CALL_ORDINAL: {
                        DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams.deserialize(messageWithHeader.getPayload());
                        getImpl().handleDistillerOpenSettingsCall();
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DistillerJavaScriptService_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class DistillerJavaScriptServiceHandleDistillerEchoCallParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String message;
    
        private DistillerJavaScriptServiceHandleDistillerEchoCallParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public DistillerJavaScriptServiceHandleDistillerEchoCallParams() {
            this(0);
        }
    
        public static DistillerJavaScriptServiceHandleDistillerEchoCallParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static DistillerJavaScriptServiceHandleDistillerEchoCallParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            DistillerJavaScriptServiceHandleDistillerEchoCallParams result = new DistillerJavaScriptServiceHandleDistillerEchoCallParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.message = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(message, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            DistillerJavaScriptServiceHandleDistillerEchoCallParams other = (DistillerJavaScriptServiceHandleDistillerEchoCallParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.message, other.message))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(message);
            return result;
        }
    }

    static final class DistillerJavaScriptServiceHandleDistillerFeedbackCallParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean good;
    
        private DistillerJavaScriptServiceHandleDistillerFeedbackCallParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public DistillerJavaScriptServiceHandleDistillerFeedbackCallParams() {
            this(0);
        }
    
        public static DistillerJavaScriptServiceHandleDistillerFeedbackCallParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static DistillerJavaScriptServiceHandleDistillerFeedbackCallParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            DistillerJavaScriptServiceHandleDistillerFeedbackCallParams result = new DistillerJavaScriptServiceHandleDistillerFeedbackCallParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.good = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(good, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            DistillerJavaScriptServiceHandleDistillerFeedbackCallParams other = (DistillerJavaScriptServiceHandleDistillerFeedbackCallParams) object;
            if (this.good != other.good)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(good);
            return result;
        }
    }

    static final class DistillerJavaScriptServiceHandleDistillerClosePanelCallParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private DistillerJavaScriptServiceHandleDistillerClosePanelCallParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public DistillerJavaScriptServiceHandleDistillerClosePanelCallParams() {
            this(0);
        }
    
        public static DistillerJavaScriptServiceHandleDistillerClosePanelCallParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static DistillerJavaScriptServiceHandleDistillerClosePanelCallParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            DistillerJavaScriptServiceHandleDistillerClosePanelCallParams result = new DistillerJavaScriptServiceHandleDistillerClosePanelCallParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams() {
            this(0);
        }
    
        public static DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams result = new DistillerJavaScriptServiceHandleDistillerOpenSettingsCallParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

}

